import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import java.io.*;

public class HttpGet extends MIDlet implements CommandListener  {
  // Chane de connexion
  private static String defaultURL = "http://j2me.netinnovations.fr/livre/HttpGet.asp?nom=toto";
  // Composant pour que l'utilisateur saisisse l'URL
  private Display myDisplay = null;
  private Form mainScreen;
  private TextField requestField;
  // Composant pour afficher le contenu de la page Web
  private Form resultScreen;
  private StringItem resultField;
  // Commande "Envoie"
  Command sendCommand = new Command("Envoi", Command.OK, 1);
  // Commande "Retour"
  Command backCommand = new Command("Retour", Command.OK, 1);

  public HttpGet() {
    // Initialisation de l'interface utilisateur
    myDisplay = Display.getDisplay(this);
    mainScreen = new Form("Entrez une URL:");
    requestField = new TextField(null, defaultURL, 100, TextField.URL);
    mainScreen.append(requestField);
    mainScreen.addCommand(sendCommand);
    mainScreen.setCommandListener(this);
  }

  public void startApp() {
    myDisplay.setCurrent(mainScreen);
  }

  public void pauseApp() {
  }

  public void destroyApp(boolean unconditional) {
  }

  public void commandAction(Command c, Displayable s) {
    // L'utilisateur a cliqu sur la commande "envoie"
    if (c == sendCommand) {
      // Rcupration de l'URL saisie
      String urlstring = requestField.getString();
      // Envoi d'une requte GET au serveur HTTP
      String resultstring = sendGetRequest(urlstring);
      // Affichage du contenu de la page rcupre du serveur HTTP
      resultScreen = new Form("Rsultat:");
      resultField  = new StringItem(null, resultstring);
      resultScreen.append(resultField);
      resultScreen.addCommand(backCommand);
      resultScreen.setCommandListener(this);
      myDisplay.setCurrent(resultScreen);
    } else if (c == backCommand) {
      // Recommence tout  zro
      requestField.setString(defaultURL);
      myDisplay.setCurrent(mainScreen); 
    }
  }

  // Envoie une requte GET au serveur HTTP
  public String sendGetRequest(String urlstring) {
    HttpConnection hc = null;
    DataInputStream dis = null;
    String message = "";
    try {
      // Ouverture d'une connexion HTTP avec le serveur Web
      // La mthode par dfaut est GET
      hc = (HttpConnection) Connector.open(urlstring);
      // Etablissement du flux en entre depuis la connexion
      dis = new DataInputStream(hc.openInputStream());
      // Lecture de la rponse du serveur HTTP caractre par caractre
      int ch;
      while ((ch = dis.read()) != -1) {
        message = message + (char) ch;
      }
    } catch (IOException ioe) {
      message = "ERROR";
    } finally {
      try {
        if (hc != null) hc.close();
      } catch (IOException ignored) {
      }
      try {
        if (dis != null) dis.close();
      } catch (IOException ignored) {
      }
    }
    return message;
  }
}
